/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.IRadiationSource;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.api.radiation.capability.IRadiationShielding;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.radiation.Meltdown;
import mekanism.common.lib.radiation.RadiationSource;
import mekanism.common.network.to_client.PacketRadiationData;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RadiationManager
implements IRadiationManager {
    public static final RadiationManager INSTANCE = new RadiationManager();
    private static final String DATA_HANDLER_NAME = "radiation_manager";
    private static final IntSupplier MAX_RANGE = () -> MekanismConfig.general.radiationChunkCheckRadius.get() * 16;
    private static final Random RAND = new Random();
    public static final double BASELINE = 1.0E-7;
    public static final double MIN_MAGNITUDE = 1.0E-5;
    private boolean loaded;
    private final Table<Chunk3D, Coord4D, RadiationSource> radiationTable = HashBasedTable.create();
    private final Table<Chunk3D, Coord4D, IRadiationSource> radiationView = Tables.unmodifiableTable(this.radiationTable);
    private final Map<ResourceLocation, List<Meltdown>> meltdowns = new Object2ObjectOpenHashMap();
    private final Object2DoubleMap<UUID> playerExposureMap = new Object2DoubleOpenHashMap();
    private RadiationScale clientRadiationScale = RadiationScale.NONE;
    private double clientEnvironmentalRadiation = 1.0E-7;
    @Nullable
    private RadiationDataHandler dataHandler;

    private RadiationManager() {
    }

    @Override
    public boolean isRadiationEnabled() {
        return MekanismConfig.general.radiationEnabled.get();
    }

    private void markDirty() {
        if (this.dataHandler != null) {
            this.dataHandler.m_77762_();
        }
    }

    @Override
    public DamageSource getRadiationDamageSource() {
        return MekanismDamageSource.RADIATION;
    }

    @Override
    public double getRadiationLevel(Entity entity) {
        return this.getRadiationLevel(new Coord4D(entity));
    }

    @Override
    public Table<Chunk3D, Coord4D, IRadiationSource> getRadiationSources() {
        return this.radiationView;
    }

    @Override
    public void removeRadiationSources(Chunk3D chunk) {
        Map chunkSources = this.radiationTable.row((Object)chunk);
        if (!chunkSources.isEmpty()) {
            chunkSources.clear();
            this.markDirty();
            this.updateClientRadiationForAll(chunk.dimension);
        }
    }

    @Override
    public void removeRadiationSource(Coord4D coord) {
        Chunk3D chunk = new Chunk3D(coord);
        if (this.radiationTable.contains((Object)chunk, (Object)coord)) {
            this.radiationTable.remove((Object)chunk, (Object)coord);
            this.markDirty();
            this.updateClientRadiationForAll(coord.dimension);
        }
    }

    @Override
    public double getRadiationLevel(Coord4D coord) {
        Set<Chunk3D> checkChunks = new Chunk3D(coord).expand(MekanismConfig.general.radiationChunkCheckRadius.get());
        double level = 1.0E-7;
        for (Chunk3D chunk : checkChunks) {
            for (Map.Entry entry : this.radiationTable.row((Object)chunk).entrySet()) {
                if (!(((Coord4D)entry.getKey()).distanceTo(coord) <= (double)MAX_RANGE.getAsInt())) continue;
                level += this.computeExposure(coord, (RadiationSource)entry.getValue());
            }
        }
        return level;
    }

    @Override
    public void radiate(Coord4D coord, double magnitude) {
        if (!this.isRadiationEnabled()) {
            return;
        }
        Map radiationSourceMap = this.radiationTable.row((Object)new Chunk3D(coord));
        RadiationSource src = (RadiationSource)radiationSourceMap.get(coord);
        if (src == null) {
            radiationSourceMap.put(coord, new RadiationSource(coord, magnitude));
        } else {
            src.radiate(magnitude);
        }
        this.markDirty();
        this.updateClientRadiationForAll(coord.dimension);
    }

    @Override
    public void radiate(LivingEntity entity, double magnitude) {
        Player player;
        if (!this.isRadiationEnabled()) {
            return;
        }
        if (!(entity instanceof Player) || MekanismUtils.isPlayingMode(player = (Player)entity)) {
            entity.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> c.radiate(magnitude * (1.0 - Math.min(1.0, this.getRadiationResistance(entity)))));
        }
    }

    @Override
    public void dumpRadiation(Coord4D coord, IGasHandler gasHandler, boolean clearRadioactive) {
        int gasTanks = gasHandler.getTanks();
        for (int tank = 0; tank < gasTanks; ++tank) {
            if (!this.dumpRadiation(coord, (GasStack)gasHandler.getChemicalInTank(tank)) || !clearRadioactive) continue;
            gasHandler.setChemicalInTank(tank, GasStack.EMPTY);
        }
    }

    @Override
    public void dumpRadiation(Coord4D coord, List<IGasTank> gasTanks, boolean clearRadioactive) {
        for (IGasTank gasTank : gasTanks) {
            if (!this.dumpRadiation(coord, (GasStack)gasTank.getStack()) || !clearRadioactive) continue;
            gasTank.setEmpty();
        }
    }

    @Override
    public boolean dumpRadiation(Coord4D coord, GasStack stack) {
        if (!stack.isEmpty() && stack.has(GasAttributes.Radiation.class)) {
            double radioactivity = stack.get(GasAttributes.Radiation.class).getRadioactivity();
            this.radiate(coord, radioactivity * (double)stack.getAmount());
            return true;
        }
        return false;
    }

    public void createMeltdown(Level world, BlockPos minPos, BlockPos maxPos, double magnitude, double chance, UUID multiblockID) {
        this.meltdowns.computeIfAbsent(world.m_46472_().m_135782_(), id -> new ArrayList()).add(new Meltdown(minPos, maxPos, magnitude, chance, multiblockID));
        this.markDirty();
    }

    public void clearSources() {
        if (!this.radiationTable.isEmpty()) {
            this.radiationTable.clear();
            this.markDirty();
            this.updateClientRadiationForAll((ServerPlayer player) -> true);
        }
    }

    private double computeExposure(Coord4D coord, RadiationSource source) {
        return source.getMagnitude() / Math.max(1.0, coord.distanceToSquared(source.getPos()));
    }

    private double getRadiationResistance(LivingEntity entity) {
        double resistance = 0.0;
        for (EquipmentSlot type : EnumUtils.ARMOR_SLOTS) {
            ItemStack stack = entity.m_6844_(type);
            Optional shielding = CapabilityUtils.getCapability((ICapabilityProvider)stack, Capabilities.RADIATION_SHIELDING_CAPABILITY, null).resolve();
            if (!shielding.isPresent()) continue;
            resistance += ((IRadiationShielding)shielding.get()).getRadiationShielding();
        }
        return resistance;
    }

    private void updateClientRadiationForAll(ResourceKey<Level> dimension) {
        this.updateClientRadiationForAll((ServerPlayer player) -> player.m_183503_().m_46472_() == dimension);
    }

    private void updateClientRadiationForAll(Predicate<ServerPlayer> clearForPlayer) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                if (!clearForPlayer.test(player)) continue;
                this.updateClientRadiation(player);
            }
        }
    }

    public void updateClientRadiation(ServerPlayer player) {
        double magnitude = this.getRadiationLevel((Entity)player);
        double scaledMagnitude = Math.ceil(magnitude / 1.0E-7);
        if (scaledMagnitude != this.playerExposureMap.getOrDefault((Object)player.m_142081_(), 0.0)) {
            this.playerExposureMap.put((Object)player.m_142081_(), scaledMagnitude);
            Mekanism.packetHandler().sendTo(PacketRadiationData.createEnvironmental(magnitude), player);
        }
    }

    public void setClientEnvironmentalRadiation(double radiation) {
        this.clientEnvironmentalRadiation = radiation;
        this.clientRadiationScale = RadiationScale.get(this.clientEnvironmentalRadiation);
    }

    public double getClientEnvironmentalRadiation() {
        return this.isRadiationEnabled() ? this.clientEnvironmentalRadiation : 1.0E-7;
    }

    public RadiationScale getClientScale() {
        return this.isRadiationEnabled() ? this.clientRadiationScale : RadiationScale.NONE;
    }

    public void tickClient(Player player) {
        if (!this.isRadiationEnabled()) {
            return;
        }
        if (this.clientRadiationScale != RadiationScale.NONE && player.f_19853_.m_5822_().nextInt(2) == 0) {
            int count = player.f_19853_.m_5822_().nextInt(this.clientRadiationScale.ordinal() * MekanismConfig.client.radiationParticleCount.get());
            int radius = MekanismConfig.client.radiationParticleRadius.get();
            for (int i = 0; i < count; ++i) {
                double x = player.m_20185_() + player.f_19853_.m_5822_().nextDouble() * (double)radius * 2.0 - (double)radius;
                double y = player.m_20186_() + player.f_19853_.m_5822_().nextDouble() * (double)radius * 2.0 - (double)radius;
                double z = player.m_20189_() + player.f_19853_.m_5822_().nextDouble() * (double)radius * 2.0 - (double)radius;
                player.f_19853_.m_7106_((ParticleOptions)MekanismParticleTypes.RADIATION.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void tickServer(ServerPlayer player) {
        this.updateEntityRadiation((LivingEntity)player);
    }

    private void updateEntityRadiation(LivingEntity entity) {
        if (!this.isRadiationEnabled()) {
            return;
        }
        LazyOptional radiationCap = entity.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY);
        if (entity.f_19853_.m_5822_().nextInt(20) == 0) {
            Player player;
            double magnitude = this.getRadiationLevel((Entity)entity);
            if (magnitude > 1.0E-7 && (!(entity instanceof Player) || MekanismUtils.isPlayingMode(player = (Player)entity))) {
                this.radiate(entity, magnitude / 3600.0);
            }
            radiationCap.ifPresent(IRadiationEntity::decay);
        }
        radiationCap.ifPresent(c -> c.update(entity));
    }

    public void tickServerWorld(Level world) {
        List dimensionMeltdowns;
        if (!this.isRadiationEnabled()) {
            return;
        }
        if (!this.loaded) {
            this.createOrLoad();
        }
        if (!(dimensionMeltdowns = this.meltdowns.getOrDefault(world.m_46472_().m_135782_(), Collections.emptyList())).isEmpty()) {
            dimensionMeltdowns.removeIf(meltdown -> meltdown.update(world));
            this.markDirty();
        }
    }

    public void tickServer() {
        Collection sources;
        if (!this.isRadiationEnabled()) {
            return;
        }
        if (RAND.nextInt(20) == 0 && !(sources = this.radiationTable.values()).isEmpty()) {
            sources.removeIf(RadiationSource::decay);
            this.markDirty();
            this.updateClientRadiationForAll((ServerPlayer player) -> true);
        }
    }

    public void createOrLoad() {
        if (this.dataHandler == null) {
            DimensionDataStorage savedData = ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
            this.dataHandler = (RadiationDataHandler)savedData.m_164861_(tag -> {
                RadiationDataHandler handler = new RadiationDataHandler();
                handler.load((CompoundTag)tag);
                return handler;
            }, RadiationDataHandler::new, DATA_HANDLER_NAME);
            this.dataHandler.setManagerAndSync(this);
            this.dataHandler.clearCached();
        }
        this.loaded = true;
    }

    public void reset() {
        this.radiationTable.clear();
        this.playerExposureMap.clear();
        this.meltdowns.clear();
        this.dataHandler = null;
        this.loaded = false;
    }

    public void resetClient() {
        this.clientRadiationScale = RadiationScale.NONE;
        this.clientEnvironmentalRadiation = 1.0E-7;
    }

    public void resetPlayer(UUID uuid) {
        this.playerExposureMap.removeDouble((Object)uuid);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Level world = event.getEntityLiving().m_20193_();
        if (!world.m_5776_() && !(event.getEntityLiving() instanceof Player)) {
            this.updateEntityRadiation(event.getEntityLiving());
        }
    }

    public static enum RadiationScale {
        NONE,
        LOW,
        MEDIUM,
        ELEVATED,
        HIGH,
        EXTREME;

        private static final double LOG_BASELINE;
        private static final double LOG_MAX;
        private static final double SCALE;

        public static RadiationScale get(double magnitude) {
            if (magnitude < 1.0E-5) {
                return NONE;
            }
            if (magnitude < 0.001) {
                return LOW;
            }
            if (magnitude < 0.1) {
                return MEDIUM;
            }
            if (magnitude < 10.0) {
                return ELEVATED;
            }
            if (magnitude < 100.0) {
                return HIGH;
            }
            return EXTREME;
        }

        public static EnumColor getSeverityColor(double magnitude) {
            if (magnitude <= 1.0E-7) {
                return EnumColor.BRIGHT_GREEN;
            }
            if (magnitude < 1.0E-5) {
                return EnumColor.GRAY;
            }
            if (magnitude < 0.001) {
                return EnumColor.YELLOW;
            }
            if (magnitude < 0.1) {
                return EnumColor.ORANGE;
            }
            if (magnitude < 10.0) {
                return EnumColor.RED;
            }
            return EnumColor.DARK_RED;
        }

        public static double getScaledDoseSeverity(double magnitude) {
            if (magnitude < 1.0E-5) {
                return 0.0;
            }
            return Math.min(1.0, Math.max(0.0, (-LOG_BASELINE + Math.log10(magnitude)) / SCALE));
        }

        public SoundEvent getSoundEvent() {
            return switch (this) {
                case LOW -> (SoundEvent)MekanismSounds.GEIGER_SLOW.get();
                case MEDIUM -> (SoundEvent)MekanismSounds.GEIGER_MEDIUM.get();
                case ELEVATED, HIGH -> (SoundEvent)MekanismSounds.GEIGER_ELEVATED.get();
                case EXTREME -> (SoundEvent)MekanismSounds.GEIGER_FAST.get();
                default -> null;
            };
        }

        static {
            LOG_BASELINE = Math.log10(1.0E-5);
            LOG_MAX = Math.log10(100.0);
            SCALE = LOG_MAX - LOG_BASELINE;
        }
    }

    public static class RadiationDataHandler
    extends SavedData {
        private Map<ResourceLocation, List<Meltdown>> savedMeltdowns = Collections.emptyMap();
        public List<RadiationSource> loadedSources = Collections.emptyList();
        public RadiationManager manager;

        public void setManagerAndSync(RadiationManager m) {
            this.manager = m;
            if (MekanismAPI.getRadiationManager().isRadiationEnabled()) {
                for (RadiationSource radiationSource : this.loadedSources) {
                    this.manager.radiationTable.put((Object)new Chunk3D(radiationSource.getPos()), (Object)radiationSource.getPos(), (Object)radiationSource);
                }
                for (Map.Entry entry : this.savedMeltdowns.entrySet()) {
                    List meltdowns = (List)entry.getValue();
                    this.manager.meltdowns.computeIfAbsent((ResourceLocation)entry.getKey(), id -> new ArrayList(meltdowns.size())).addAll(meltdowns);
                }
            }
        }

        public void clearCached() {
            this.loadedSources = Collections.emptyList();
            this.savedMeltdowns = Collections.emptyMap();
        }

        public void load(@Nonnull CompoundTag nbtTags) {
            if (nbtTags.m_128425_("radList", 9)) {
                ListTag list = nbtTags.m_128437_("radList", 10);
                this.loadedSources = new HashList<RadiationSource>(list.size());
                for (Tag nbt2 : list) {
                    this.loadedSources.add(RadiationSource.load((CompoundTag)nbt2));
                }
            } else {
                this.loadedSources = Collections.emptyList();
            }
            if (nbtTags.m_128425_("meltdowns", 10)) {
                CompoundTag meltdownNBT = nbtTags.m_128469_("meltdowns");
                this.savedMeltdowns = new HashMap<ResourceLocation, List<Meltdown>>(meltdownNBT.m_128440_());
                for (String dim : meltdownNBT.m_128431_()) {
                    ResourceLocation dimension = ResourceLocation.m_135820_((String)dim);
                    if (dimension == null) continue;
                    ListTag meltdowns = meltdownNBT.m_128437_(dim, 10);
                    this.savedMeltdowns.put(dimension, meltdowns.stream().map(nbt -> Meltdown.load((CompoundTag)nbt)).collect(Collectors.toList()));
                }
            } else {
                this.savedMeltdowns = Collections.emptyMap();
            }
        }

        @Nonnull
        public CompoundTag m_7176_(@Nonnull CompoundTag nbtTags) {
            if (!this.manager.radiationTable.isEmpty()) {
                ListTag list = new ListTag();
                for (RadiationSource radiationSource : this.manager.radiationTable.values()) {
                    CompoundTag compound = new CompoundTag();
                    radiationSource.write(compound);
                    list.add((Object)compound);
                }
                nbtTags.m_128365_("radList", (Tag)list);
            }
            if (!this.manager.meltdowns.isEmpty()) {
                CompoundTag meltdownNBT = new CompoundTag();
                for (Map.Entry entry : this.manager.meltdowns.entrySet()) {
                    List meltdowns = (List)entry.getValue();
                    if (meltdowns.isEmpty()) continue;
                    ListTag list = new ListTag();
                    for (Meltdown meltdown : meltdowns) {
                        CompoundTag compound = new CompoundTag();
                        meltdown.write(compound);
                        list.add((Object)compound);
                    }
                    meltdownNBT.m_128365_(((ResourceLocation)entry.getKey()).toString(), (Tag)list);
                }
                if (!meltdownNBT.m_128456_()) {
                    nbtTags.m_128365_("meltdowns", (Tag)meltdownNBT);
                }
            }
            return nbtTags;
        }
    }
}

